/**
 * Simple saving system for weapons/loadout
 * by iFarbod (12:02 2014-07-24)
 */

// Here is the includes
// SA:MP Server Functions
#include <a_samp>

// y_ini
#include <YSI\y_ini>

// YSF (Thanks to kurta999)
//#include <YSF>

// Definitions
#define LOADOUT_PATH "PlayerWeapons/%s.ini"

// Global Vars
new
	gPlayerWeapons[MAX_PLAYERS][13][2];

new
	Float:gPlayerHealth[MAX_PLAYERS],
	Float:gPlayerArmour[MAX_PLAYERS],
	gFightingStyle[MAX_PLAYERS];

// Callbacks and what we'll need
public OnFilterScriptInit()
{
	print("\n*** Simple Weapons Saving FS loaded. ***\n");
	dcreate("PlayerWeapons");
	return 1;
}

public OnFilterScriptExit()
{
	print("\n*** Simple Weapons Saving FS unloaded. ***\n");
	return 1;
}

public OnPlayerConnect(playerid)
{
    INI_ParseFile(LoadoutPath(playerid), "LoadWeapons_%s", .bExtra = true, .extra = playerid);

    if(!fexist(LoadoutPath(playerid)))
    {
	    new
	        INI:File = INI_Open(LoadoutPath(playerid));

		INI_SetTag(File, "Loadout");
		INI_WriteFloat(File, "Health", 100.0, 1);
		INI_Close(File);
	}
	return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
	#pragma unused reason

	new
	    tmpPlayerWeapons[13][2],
		Float:tmpPlayerHealth,
		Float:tmpPlayerArmour,
		tmpString[64],
		INI:tmpFile;

    for(new i = 0; i <= 12; i++)
	{
	    GetPlayerWeaponData(playerid, i, tmpPlayerWeapons[i][0], tmpPlayerWeapons[i][1]);
	}

	GetPlayerHealth(playerid, tmpPlayerHealth);
	GetPlayerArmour(playerid, tmpPlayerArmour);

	tmpFile = INI_Open(LoadoutPath(playerid));
	INI_SetTag(tmpFile, "Loadout");

	for(new i = 0; i <= 12; i++)
	{
	    format(tmpString, sizeof(tmpString), "WeaponSlot%d", i);
    	INI_WriteInt(tmpFile, tmpString, tmpPlayerWeapons[i][0]);
    	format(tmpString, sizeof(tmpString), "WeaponSlot%dAmmo", i);
    	INI_WriteInt(tmpFile, tmpString, tmpPlayerWeapons[i][1]);
	}

	INI_WriteFloat(tmpFile, "Health", tmpPlayerHealth, 1);
	INI_WriteFloat(tmpFile, "Armour", tmpPlayerArmour, 1);
	INI_WriteInt(tmpFile, "FightingStyle", GetPlayerFightingStyle(playerid));
	INI_Close(tmpFile);
	return 1;
}

public OnPlayerSpawn(playerid)
{
	ResetPlayerWeapons(playerid);
    for(new i = 0; i <= 12; i++)
	{
	    GivePlayerWeapon(playerid, gPlayerWeapons[playerid][i][0], gPlayerWeapons[playerid][i][1]);
	}

	SetPlayerHealth(playerid, gPlayerHealth[playerid]);
	SetPlayerArmour(playerid, gPlayerArmour[playerid]);
	SetPlayerFightingStyle(playerid, gFightingStyle[playerid]);
	return 1;
}

// Custom Functions
forward LoadWeapons_Loadout(playerid, name[], value[]);
public LoadWeapons_Loadout(playerid, name[], value[])
{
	new
		szTmp[64];

    for(new i = 0; i <= 12; i++)
	{
	    format(szTmp, sizeof(szTmp), "WeaponSlot%d", i);
    	INI_Int(szTmp, gPlayerWeapons[playerid][i][0]);
    	format(szTmp, sizeof(szTmp), "WeaponSlot%dAmmo", i);
    	INI_Int(szTmp, gPlayerWeapons[playerid][i][1]);
	}

	INI_Float("Health", gPlayerHealth[playerid]);
	INI_Float("Armour", gPlayerArmour[playerid]);
	INI_Int("FightingStyle", gFightingStyle[playerid]);
	return 1;
}

stock PlayerName(playerid)
{
	new
		playerName[MAX_PLAYER_NAME+1];

	GetPlayerName(playerid, playerName, sizeof(playerName));
	return playerName;
}

stock PlayerNameEx(playerid)
{
	new
		playerName[MAX_PLAYER_NAME+1],
		string[MAX_PLAYER_NAME+1+7];

	GetPlayerName(playerid, playerName, sizeof(playerName));
	format(string, sizeof(string), "%s (%d)", playerName, playerid);
	return string;
}

stock LoadoutPath(playerid)
{
	new
	    string[128];

	format(string, sizeof(string), LOADOUT_PATH, PlayerName(playerid));
	return string;
}
